class BlackHole extends Effects;

#exec Texture Import File=C:\DeusEx\MSInventions1_3\Textures\BlackHole.pcx Name=BlackHole GROUP="Effects"
#exec OBJ LOAD FILE=MSPGFX

var bool bDying;
var float size;
var float radius;
var float reach;
var float ShockTime;
var float PhaseTime;
var float curTime;
var vector curRot; //current rotation for actors to swirl around
//var Actor list[4096];
var int len;
var ParticleGenerator sparkGen;

simulated function bool CanAffect(Actor act)
{
	return !act.bStatic && !act.IsA('ParticleProxy') && act.bCollideWorld &&
		(act.IsA('DeusExFragment') || act.bCollideActors &&
		act.bBlockActors && act.bBlockPlayers &&
		(act.IsA('Decoration') && Decoration(act).bPushable && !act.IsA('ParticleProxy') ||
		act.IsA('Pawn')));
}

simulated function Tick(float deltaTime)
{
	local float speed;
	local Actor act;
	local vector loc;
	local int i, dmg;
	local rotator rot;
	super.Tick(deltaTime);
	if(curTime<ShockTime)
	{
		curTime+=deltaTime;
		if(curTime>=ShockTime)
		{
			act=Spawn(Class'SphereEffect',,,);
			SphereEffect(act).size=size*1.5;
			act.Style=STY_Normal;
			act.Skin=Skin;
			Lifespan=Default.Lifespan;
			len=0;
			foreach RadiusActors(Class'Actor', act, reach, Location)
			{
				if(CanAffect(act))
				{
					curTime -= DeltaTime / 3; //keep growing!
					dmg=50;
					act.SetPhysics(PHYS_Falling);
//					if(len<4096)
//						list[len++]=act;
					loc = act.Location - Location;
//					act.Velocity=Normal(loc)*10000;
					act.Velocity.y=-1000;
					if(act.IsA('DeusExFragment'))
					{
						dmg=0;
					}
					act.TakeDamage(dmg, None, act.Location, Normal(loc)*100, 'Exploded'); //exploded gibs
					if(!act.IsA('Pawn'))
					{
						act.Velocity=VRand()*1000;
					}
				}
			}
			return;
		}

		if(curTime<PhaseTime)
		{
			speed=curTime/PhaseTime*500;
			DrawScale+=0.1/PhaseTime;
			ScaleGlow+=0.1/PhaseTime;
		}
		else
                {
			speed=500;
		}
		rot=rot(0,0,0);
		rot.yaw=65536*5*deltaTime/ShockTime;
		curRot = curRot >> rot;
		foreach RadiusActors(Class'Actor', act, reach, Location)
		{
			if(CanAffect(act) && (!act.IsA('DeusExFragment') || act.IsA('FleshFragment')))
			{
				dmg=0;
				act.SetPhysics(PHYS_Falling);
				loc = Location  - act.Location; //dest
				//* Normal(curRot) + Normal(act.Location-Location)*radius/**ShockTime/curTime*/
				}

				if(VSize(Location-act.Location)<radius*20)
				{
					if(act.IsA('DeusExCarcass'))
                                        {
						DeusExCarcass(act).ChunkUp(100);
                                        }
//					else if (!act.IsA('FleshFragment'))
						dmg=1; //kills very quickly doing enough damage to gib most critters
				}
//				if(VSize(act.Velocity) < speed/4)
				act.Velocity=(Normal(loc+Normal(curRot)*radius) + (2*Normal(curRot)+VRand())/3)*speed;
				if(act.IsA('ScriptedPawn'))
				{
					act.Velocity.z=Normal(loc).z*speed;
				}
//				if(act.IsA('DeusExFragment')) 
					if(act.IsA('FleshFragment') && act.Lifespan < 5.0)
                                         {
						act.Lifespan=5.0 + ShockTime;
					 }
				else
                                {
					act.TakeDamage(dmg, None, act.Location, Normal(loc)*10, 'Exploded'); //ow!
                                }
				if(act.IsA('ScriptedPawn') && ScriptedPawn(act).health<0)
				{
					act.PlaySound(Sound'VortexBodyExplode',SLOT_None,2.0,,radius*20);
					Spawn(class'ExplosionMedium',,, act.Location);
					//just gib it!
					ScriptedPawn(act).health=-200;
					ScriptedPawn(act).SpawnCarcass();
					act.Destroy();
				}
			}
		}
			
//	}
	else
	{
		DrawScale = 6.0 * size * (Default.LifeSpan - LifeSpan) / Default.LifeSpan;
		ScaleGlow = 4.0 * (LifeSpan / Default.LifeSpan);
		if(!bDying)
		{
			PlaySound(Sound'VortexDie',SLOT_None,2.0,,radius*24);
			bDying=true;
		}
	}
}

function PostBeginPlay()
{
	super.PostBeginPlay();
	PlaySound(Sound'VortexIntro',SLOT_None,2.0,,radius*24);
//	SoundRadius=radius*1.25;
	AmbientSound=Sound'VortexAmbient';
	DrawScale = 0.09 * size;
	ScaleGlow = 4.0;
	LifeSpan=0; //live to do the shockwave effect
	curTime=0;
	curRot=vect(1,0,1);
        SpawnSparkEffects();
}

simulated function SpawnSparkEffects()
{
	sparkGen = Spawn(class'ParticleGenerator', Self);
	if (sparkGen != None)
	{
      sparkGen.RemoteRole = ROLE_None;
		sparkGen.particleTexture = FireTexture'MSPGFX.BH.BHFlash';
		sparkGen.particleDrawScale = 0.5;
		sparkGen.checkTime = 0.25;
		sparkGen.ejectSpeed = 96.0;
		sparkGen.particleLifeSpan = 2.0;
		sparkGen.bRandomEject = True;
		sparkGen.SetBase(Self);
	}
}

simulated function Destroyed()
{
	if (sparkGen != None)
		sparkGen.DelayedDestroy();

	Super.Destroyed();
}

defaultproperties
{
     size=5.000000
     Radius=80.000000
     reach=240.000000
     ShockTime=15.000000
     PhaseTime=3.000000
     LifeSpan=0.500000
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExItems.FlatFX'
     Style=STY_Translucent
     Texture=Texture'BlackHole'
     Skin=Texture'BlackHole'
     bUnlit=True
}
